package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.entity.ContentType;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.http.HttpHeaderNames;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class SupportedPreviewMimeTypesAction extends HttpServlet implements BackendServlet {
    private static final Logger logger = LoggerFactory.getLogger(SupportedPreviewMimeTypesAction.class);
    private static final BenderJsonSerializer<ConvertationInfo> serializer = Bender.jsonSerializer(ConvertationInfo.class);
    private final ConvertationInfo convertationInfo;

    @BenderBindAllFields
    static class ConvertationInfo {
        public final SetF<String> previewMimeTypes;
        public final DataSize maxFileSize;

        public ConvertationInfo(SetF<String> previewMimeTypes, DataSize maxFileSize) {
            this.previewMimeTypes = previewMimeTypes;
            this.maxFileSize = maxFileSize;
        }
    }

    public SupportedPreviewMimeTypesAction(SetF<String> supportedMimeTypes, DataSize maxFileSize) {
        this.convertationInfo = new ConvertationInfo(supportedMimeTypes, maxFileSize);

    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            byte[] serializedResult = serializer.serializeJson(convertationInfo);
            resp.getOutputStream().write(serializedResult);
            resp.addHeader(HttpHeaderNames.CONTENT_TYPE, ContentType.APPLICATION_JSON.getMimeType());
            resp.addHeader(HttpHeaderNames.CONTENT_LENGTH, "" + serializedResult.length);
        } catch (Exception e) {
            logger.error("Exception occurred: {}", e);
            resp.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public String getActionUrl() {
        return "/preview-supported";
    }
}
