package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.UriHelper;
import ru.yandex.chemodan.app.docviewer.log.DvStages;
import ru.yandex.chemodan.app.docviewer.states.StateMachine;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.misc.lang.StringUtils;

@SuppressWarnings("serial")
public class UrlInfoAction extends AbstractXmlActionServlet<UrlInfoRequest> implements BackendServlet {

    @Autowired
    private StateMachine stateMachine;

    @Autowired
    private UriHelper uriHelper;

    @Override
    public String getActionUrl() {
        return "/urlinfo";
    }

    @Override
    public void execute(UrlInfoRequest request, Document doc) {
        DocumentSourceInfo source = DocumentSourceInfo.builder().originalUrl(request.url).uid(request.uid)
                .archivePath(StringUtils.notEmptyO(request.archivePath)).build()
                .withShowNda(request.showNda);

        ActualUri actualUri = DvStages.VALIDATE_URI.log(
                Tuple2List.fromPairs("source", source),
                () -> uriHelper.rewrite(source),
                uri -> Tuple2List.fromPairs("uri", uri)
        );
        doc.add(stateMachine.getInfo(actualUri, request.session));
    }
}
