package ru.yandex.chemodan.app.docviewer.web.framework;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.XmlSerializer;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.misc.reflection.GenericUtils;

@SuppressWarnings("serial")
public abstract class AbstractXmlActionServlet<T extends DocviewerRequest> extends AbstractActionServlet<T> {

    @Autowired
    protected XmlSerializer xmlSerializer;

    @Override
    protected void doGetImpl(HttpServletRequest req, T request, HttpServletResponse resp) {
        Document doc = DocumentHelper.createDocument();
        execute(request, doc);
        Document result = doc;
        XmlActionUtils.serializeAndWriteResult(xmlSerializer, resp, result, request.json);
    }

    protected void sendError(final int code, Throwable he, HttpServletResponse resp, Option<T> req) throws IOException {
        if (!req.isPresent()) {
            super.sendError(code, he , resp, req);
            return;
        }
        resp.setStatus(code);
        XmlActionUtils.serializeAndWriteResult(xmlSerializer, resp,  XmlActionUtils.errorXml(he), req.get().json);
    }

    public abstract void execute(T request, Document doc);

    @Override
    protected Class<T> getRequestClass() {
        return (Class<T>) GenericUtils.getSingleSpecializationParameter(this.getClass());
    }

    protected TargetType getConvertTargetMobileIncluded(DocviewerRequest request) {
        return request.mobile ? TargetType.HTML_WITH_IMAGES_FOR_MOBILE : TargetType.HTML_WITH_IMAGES;
    }
}
