package ru.yandex.chemodan.app.docviewer.web.framework;

import java.net.URI;
import java.util.List;

import javax.servlet.http.Cookie;

import ru.yandex.chemodan.app.docviewer.web.framework.exception.ReturnHttpCodeException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.lang.Validate;

@SuppressWarnings("serial")
public class FoundException extends ReturnHttpCodeException {
    private final URI uri;
    private final List<Cookie> cookies;

    public FoundException(URI uri, List<Cookie> cookies) {
        Validate.notNull(uri, "uri");
        Validate.notNull(cookies, "cookies");
        this.uri = uri;
        this.cookies = cookies;
    }

    @Override
    public int getStatusCode() {
        return HttpStatus.SC_302_MOVED_TEMPORARILY;
    }

    public URI getUri() {
        return uri;
    }

    public List<Cookie> getCookies() {
        return cookies;
    }
}
