package ru.yandex.chemodan.app.docviewer.web.framework;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.chemodan.app.docviewer.utils.MaintenanceFileChecker;
import ru.yandex.chemodan.app.docviewer.web.backend.RateLimiter;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@SuppressWarnings("serial")
public class PingServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(PingServlet.class);

    @Autowired
    @Qualifier("mongoDbAdapter")
    private MongoDbAdapter mongoDbAdapter;
    @Autowired
    private MaintenanceFileChecker maintenanceFileChecker;

    @Value("${actions.ping.reply}")
    private String reply;

    @Autowired
    private RateLimiter rateLimiter;

    private final boolean checkDbConnection;

    public PingServlet() {
        this(false);
    }

    public PingServlet(boolean checkDbConnection) {
        this.checkDbConnection = checkDbConnection;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setCharacterEncoding("utf-8");
        resp.setContentType("text/plain");

        if (checkDbConnection && !mongoDbAdapter.hasServerUp()) {
            resp.setStatus(HttpServletResponse.SC_SERVICE_UNAVAILABLE);
            logger.error("ping failed: MongoDB is not available");
            resp.getWriter().write("MongoDB is not available");
        } else if (maintenanceFileChecker.exists()) {
            resp.setStatus(HttpServletResponse.SC_SERVICE_UNAVAILABLE);
            logger.error("ping failed: maintenanceFileChecker.exists()");
            resp.getWriter().write("fail /ping");
        } else if (rateLimiter.checkRejectRequest()) {
            resp.setStatus(HttpServletResponse.SC_SERVICE_UNAVAILABLE);
            logger.error("ping failed: rateLimiter.checkRejectRequest()");
            rateLimiter.logReject();
            resp.getWriter().write("request Limited");
        } else {
            resp.getWriter().write(reply);
        }
    }
}
