package ru.yandex.chemodan.app.docviewer.web.framework;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

import javax.servlet.ServletResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.WriterSource;
import ru.yandex.misc.lang.Check;

/**
 * @author vlsergey
 */
public class ServletResponseOutputStreamSource extends OutputStreamSource {

    private final ServletResponse servletResponse;
    private boolean used = false;

    public ServletResponseOutputStreamSource(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    @Override
    public WriterSource asWriterTool(Charset charset) {
        return new ServletResponseWriterSource(servletResponse, charset.name());
    }

    @Override
    public void writeFrom(InputStreamSource inputStreamSource) {
        final Option<Long> lengthO = inputStreamSource.lengthO();
        if (lengthO.isPresent()) {
            if (lengthO.get() < Integer.MAX_VALUE) {
                servletResponse.setContentLength(lengthO.get().intValue());
            }
        }

        super.writeFrom(inputStreamSource);
    }

    @Override
    public WriterSource asWriterTool(String charsetName) {
        return new ServletResponseWriterSource(servletResponse, charsetName);
    }

    @Override
    public OutputStream getOutput() throws IOException {
        Check.C.isFalse(used);
        used = true;
        return servletResponse.getOutputStream();
    }
}
