package ru.yandex.chemodan.app.docviewer.web.framework;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.ServletResponse;

import ru.yandex.misc.io.WriterSource;

public class ServletResponseWriterSource extends WriterSource {
    private final String charset;

    private final ServletResponse servletResponse;

    public ServletResponseWriterSource(ServletResponse servletResponse, String charset) {
        this.servletResponse = servletResponse;
        this.charset = charset;
    }

    public String getCharset() {
        return charset;
    }

    @Override
    public Writer getOutput() throws IOException {
        servletResponse.setCharacterEncoding(charset);
        return servletResponse.getWriter();
    }

    public ServletResponse getServletResponse() {
        return servletResponse;
    }
}
