package ru.yandex.chemodan.app.docviewer.web.framework;

import javax.servlet.http.HttpServletResponse;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONObject;
import org.json.XML;

import ru.yandex.chemodan.app.docviewer.utils.XmlSerializer;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author akirakozov
 */
public class XmlActionUtils {
    public static void serializeAndWriteResult(
            XmlSerializer xmlSerializer, HttpServletResponse resp, Document result, boolean useJson)
    {
        /*
         * TODO: check XML for correctness, for example check it doesn't have
         * invalid chars (like &#27;);
         */
        try {
            resp.setCharacterEncoding("utf-8");

            if (useJson) {
                resp.setContentType("application/json");
                String resultXmlString = Dom4jUtils.writeToString(result.getRootElement());
                JSONObject resultJsonObject = XML.toJSONObject(resultXmlString);
                resp.getOutputStream().write(resultJsonObject.toString().getBytes());
            } else {
                resp.setContentType("text/xml");
                xmlSerializer.serializeToXml(result, resp.getOutputStream());
            }
        } catch (Exception exc) {
            throw ExceptionUtils.translate(exc);
        }
    }

    public static Document errorXml(Throwable exc) {
        Document doc = DocumentHelper.createDocument();

        // TODO: check if there is a standard XML for errors in XScript
        Element root = DocumentHelper.createElement("error");
        doc.add(root);

        root.addElement("class").addText(exc.getClass().getName());

        if (StringUtils.isNotEmpty(exc.getMessage()))
            root.addElement("message").addText(exc.getMessage());

        if (StringUtils.isNotEmpty(exc.getLocalizedMessage()))
            root.addElement("localized-message").addText(exc.getLocalizedMessage());

        return doc;
    }

}
