package ru.yandex.chemodan.app.docviewer.web.framework.tvm;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmHeaders;
import ru.yandex.inside.passport.tvm2.exceptions.MissingTvmServiceTicketException;
import ru.yandex.inside.passport.tvm2.exceptions.MissingTvmUserTicketException;

/**
 * @author akirakozov
 */
public class Tvm2Utils {

    public static void checkAuthentication(Tvm2 tvm2, HttpServletRequest request) {
        Option<String> serviceTicket = Option.ofNullable(request.getHeader(TvmHeaders.SERVICE_TICKET));
        if (!serviceTicket.isPresent()) {
            throw new MissingTvmServiceTicketException();
        }

        int srcClientId = tvm2.checkServiceTicketBySrc(serviceTicket.get());

        if (tvm2.skipUserTicketChecking(srcClientId)) {
            return;
        }

        Option.ofNullable(request.getParameter("uid"))
                .filterNot(String::isEmpty).map(Long::valueOf).filter(uid -> uid != 0).forEach(uid -> {
            Option<String> userTicket = Option.ofNullable(request.getHeader(TvmHeaders.USER_TICKET));
            if (!userTicket.isPresent()) {
                throw new MissingTvmUserTicketException();
            }

            tvm2.checkUserTicketByUid(userTicket.get(), uid);
        });
    }

}
