package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.cleanup.CleanupManager;
import ru.yandex.chemodan.app.docviewer.web.EmptyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class CleanupHourAction extends AbstractActionServlet<EmptyRequest> implements ServiceServlet {

    @Autowired
    private CleanupManager cleanupManager;

    @Override
    public String getActionUrl() {
        return "/cleanuphour";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, EmptyRequest request, HttpServletResponse resp) {
        cleanupManager.cleanupHour();

        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent("ok".getBytes(), "text/plain");
    }
}
