package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfImageCache;
import ru.yandex.chemodan.app.docviewer.web.EmptyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class CleanupPdfImageCacheAction extends AbstractActionServlet<EmptyRequest> implements ServiceServlet {

    @Autowired
    private PdfImageCache pdfImageCache;

    @Override
    public String getActionUrl() {
        return "/cleanuppdfimagecache";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, EmptyRequest request, HttpServletResponse resp) {
        pdfImageCache.removeAll(TimeUtils.now());

        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent("ok".getBytes(), "text/plain");
    }
}
