package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.cleanup.CleanupManager;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupUidAction.UidRequest;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class CleanupUidAction extends AbstractActionServlet<UidRequest> implements ServiceServlet {

    @Autowired
    private CleanupManager cleanupManager;

    public static class UidRequest extends DocviewerRequest {
        @ActionParameter
        private PassportUidOrZero uid;
    }

    @Override
    public String getActionUrl() {
        return "/cleanupuid";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, UidRequest request, HttpServletResponse resp) {
        int foundCount = cleanupManager.cleanupByUid(request.uid);

        String msg = "By " + request.uid + ", " + foundCount + " uri(s) has been found";
        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent(msg.getBytes(), "text/plain");
    }

}
