package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.cleanup.CleanupManager;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.UriHelper;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupUriAction.UrlRequest;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class CleanupUriAction extends AbstractActionServlet<UrlRequest> implements ServiceServlet {

    @Autowired
    private UriHelper uriHelper;
    @Autowired
    private CleanupManager cleanupManager;

    public static class UrlRequest extends DocviewerRequest {
        @ActionParameter
        private String url;

        @ActionParameter
        private PassportUidOrZero uid;

    }

    @Override
    public String getActionUrl() {
        return "/cleanupuri";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, UrlRequest request, HttpServletResponse resp) {
        ActualUri actualUri = uriHelper.rewrite(
                DocumentSourceInfo.builder().originalUrl(request.url).uid(request.uid).build().withShowNda(request.showNda));
        boolean found = cleanupManager.cleanupByActualUri(actualUri);

        String msg = found ? "ok" : "Uri " + request.url + " wasn't found";
        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent(msg.getBytes(), "text/plain");
    }

}
