package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.chemodan.app.docviewer.utils.MemoryUtils;
import ru.yandex.chemodan.app.docviewer.web.EmptyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class InfoAction extends AbstractActionServlet<EmptyRequest> implements ServiceServlet {

    @Override
    public String getActionUrl() {
        return "/info";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, EmptyRequest request, HttpServletResponse resp) {
        String memoryInfoMessage = MemoryUtils.getOverallInfo() + "\n";

        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent(memoryInfoMessage.getBytes(), "text/plain");
    }
}
