package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.cleanup.ResultsCleanup;
import ru.yandex.chemodan.app.docviewer.web.EmptyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

@SuppressWarnings("serial")
public class RemoveResultsAction extends AbstractActionServlet<EmptyRequest> implements ServiceServlet {

    @Autowired
    private ResultsCleanup resultsCleanup;

    @Override
    public String getActionUrl() {
        return "/removeresults";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, EmptyRequest request, HttpServletResponse resp) {
        resultsCleanup.removeAll(TimeUtils.now());

        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent("ok".getBytes(), "text/plain");
    }
}
