package ru.yandex.chemodan.app.docviewer.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.cleanup.UriCleanup;
import ru.yandex.chemodan.app.docviewer.web.EmptyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

@SuppressWarnings("serial")
public class RemoveUrisAction extends AbstractActionServlet<EmptyRequest> implements ServiceServlet {

    @Autowired
    private UriCleanup uriCleanup;

    @Override
    public String getActionUrl() {
        return "/removeuris";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, EmptyRequest request, HttpServletResponse resp) {
        uriCleanup.removeAll(TimeUtils.now());

        resp.setCharacterEncoding("utf-8");
        HttpServletResponseX.wrap(resp).writeContent("ok".getBytes(), "text/plain");
    }
}
