package ru.yandex.chemodan.app.docviewer.yt;

import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.env.EnvironmentType;

public class YtPathUtils {

    private static final String DOCVIEWER_DOCUMENTS_CLEANUP_PATH = "document-cleanup";

    private static final String DOCVIEWER_DOCUMENTS_CLEANUP_TEMP_PATH = "document-cleanup-temp";

    private static final String DOCVIEWER_DOCUMENTS_CLEANUP_PROCESSOR_PATH = "document-cleanup-processor/1d";

    private static final String DOCVIEWER_DOCUMENTS_CLEANUP_ROOT_PATH = "documents-cleanup-root";

    private static final String DOCVIEWER_IMAGES_CLEANUP_PATH = "images-cleanup";

    private static final String DOCVIEWER_IMAGES_CLEANUP_TEMP_PATH = "images-cleanup-temp";

    private static final String DOCVIEWER_IMAGES_CLEANUP_PROCESSOR_PATH = "images-cleanup-processor/1d";

    private static final String DOCVIEWER_IMAGES_CLEANUP_ROOT_PATH = "images-cleanup-root";

    public static YPath getDocumentsCleanupYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_DOCUMENTS_CLEANUP_PATH);
    }

    public static YPath getDocumentsCleanupTempYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_DOCUMENTS_CLEANUP_TEMP_PATH);
    }

    public static YPath getDocumentsCleanupProcessorYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_DOCUMENTS_CLEANUP_PROCESSOR_PATH);
    }

    public static YPath getDocumentsCleanupRootYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_DOCUMENTS_CLEANUP_ROOT_PATH);
    }

    public static YPath getImagesCleanupYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_IMAGES_CLEANUP_PATH);
    }

    public static YPath getImagesCleanupTempYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_IMAGES_CLEANUP_TEMP_PATH);
    }

    public static YPath getImagesCleanupProcessorYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_IMAGES_CLEANUP_PROCESSOR_PATH);
    }

    public static YPath getImagesCleanupRootYPath() {
        return YPath.simple(getDocviewerStatsHomeFolderPath() + DOCVIEWER_IMAGES_CLEANUP_ROOT_PATH);
    }

    public static YPath getDocviewerTskvLogPath() {
        return YPath.simple("//logs/ydisk-docviewer-web-log/1d");
    }

    public static YPath getDocviewerEventsLogPath() {
        return YPath.simple("//logs/ydisk-docviewer-web-events-log/1d");
    }

    private static String addTestingFolderIfNeeded(String path) {
        return EnvironmentType.getActive() != EnvironmentType.PRODUCTION ? path + "testing/" : path;
    }

    private static String getDocviewerStatsHomeFolderPath() {
        return addTestingFolderIfNeeded("//home/mpfs-stat/docviewer/");
    }
}
