/*
 * Author: akirakozov
 * Hack to avoid network connection for libreoffice and other application
 * https://st.yandex-team.ru/DOCVIEWER-1953
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <sys/socket.h>
#include <dlfcn.h>
#include <errno.h>
 
typedef int (*orig_connect_f_type)(int socket, const struct sockaddr* address, socklen_t address_len);
  
int connect(int socket, const struct sockaddr* address, socklen_t address_len) {    
    //printf("Family: %d\n", address->sa_family); 
    //printf("%s\n", address->sa_data);
        
    if (address->sa_family != AF_INET && address->sa_family != AF_INET6) {
        orig_connect_f_type orig_connect;
        orig_connect = (orig_connect_f_type)dlsym(RTLD_NEXT,"connect");
        return orig_connect(socket, address, address_len);
    } else {
        errno = ECONNREFUSED;
        return -1;
    }
}

