<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:fb="http://www.gribuser.ru/xml/fictionbook/2.0"
    exclude-result-prefixes="xsl xhtml xlink fb"
    >

<xsl:output method="html" encoding="utf-8"/>

<xsl:strip-space elements="
            fb:body
            fb:section
            fb:coverpage
            fb:annotation
            fb:title
            fb:poem
            fb:stanza
            fb:epigraph
            fb:cite
        "/>

<xsl:template match="/fb:FictionBook">
    <html>
        <head/>

        <body>
            <xsl:apply-templates select="fb:description/fb:title-info"/>
            <xsl:apply-templates select="fb:body"/>
        </body>
    </html>
</xsl:template>

<xsl:template match="fb:title-info">
    <h1 class="fb2-book-title">
        <xsl:apply-templates select="fb:author"/>
        <xsl:value-of select="fb:book-title"/>
    </h1>
    <xsl:apply-templates select="fb:coverpage"/>
    <xsl:apply-templates select="fb:annotation"/>
</xsl:template>

<xsl:template match="fb:author">
    <xsl:value-of select="fb:nickname"/>
    <br/>
</xsl:template>

<xsl:template match="fb:author[fb:first-name]">
    <xsl:value-of select="fb:first-name"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="fb:last-name"/>
    <br/>
</xsl:template>

<xsl:template match="fb:section[@id]">
    <div class="fb2-section">
        <xsl:copy-of select="@id"/>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="fb:body/fb:title">
    <h2><xsl:apply-templates/></h2>
</xsl:template>

<xsl:template match="fb:section/fb:title">
    <h3><xsl:apply-templates/></h3>
</xsl:template>

<xsl:template match="fb:section/fb:section/fb:title">
    <h4><xsl:apply-templates/></h4>
</xsl:template>

<xsl:template match="fb:title">
    <h5><xsl:apply-templates/></h5>
</xsl:template>

<xsl:template match="fb:title/fb:p">
    <xsl:if test="position() != 1">
        <xsl:text>&#32;</xsl:text>
    </xsl:if>
    <span class="fb2-title-p">
        <xsl:apply-templates/>
    </span>
</xsl:template>

<xsl:template match="
            fb:coverpage
            | fb:annotation
            | fb:subtitle
            | fb:epigraph
            | fb:poem
            | fb:stanza
            | fb:text-author
            | fb:empty-line
        ">
    <div class="fb2-{local-name()}">
        <xsl:copy-of select="@id"/>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="
            fb:p
            | fb:strong
            | fb:sup
            | fb:sub
            | fb:code
        ">
    <xsl:element name="{local-name()}">
        <xsl:apply-templates/>
    </xsl:element>
</xsl:template>

<xsl:template match="fb:emphasis">
    <em>
        <xsl:apply-templates/>
    </em>
</xsl:template>

<xsl:template match="fb:strikethrough">
    <del>
        <xsl:apply-templates/>
    </del>
</xsl:template>

<xsl:template match="fb:cite">
    <blockquote>
        <xsl:apply-templates/>
    </blockquote>
</xsl:template>

<xsl:template match="fb:v">
    <p>
        <xsl:apply-templates/>
    </p>
</xsl:template>

<xsl:template match="fb:a" name="fb:a">
    <a href="{@xlink:href}">
        <xsl:apply-templates/>
    </a>
</xsl:template>

<xsl:template match="fb:a[@type = 'note']">
    <sup class="fb2-note">
        <xsl:call-template name="fb:a"/>
    </sup>
</xsl:template>

<xsl:template match="fb:image">
    <xsl:variable name="id" select="substring(@xlink:href, 2)"/>
    <!-- see HtmlPostprocessor#addLocalImageSrc -->
    <img x-docviewer-img-local-src="{$id}"/>
</xsl:template>

</xsl:stylesheet>
