package ru.yandex.chemodan.app.docviewer.adapters.freehep;

import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.utils.ByteArrayOutputStreamSource;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

public class FreeHepAdapterTest {
    private  static final int SIZE_LIMIT = 1536;

    @Test
    public void testConvertEmfToSvg() {
        FreeHepAdapter freeHepAdapter = new FreeHepAdapter(SIZE_LIMIT);

        freeHepAdapter.convertEmfToSvg(new UrlInputStreamSource(TestResources.Microsoft_EMF),
                new DevNullOutputStreamSource());
    }

    @Test
    public void testConvertEmfWithPngToSvg() {
        FreeHepAdapter freeHepAdapter = new FreeHepAdapter(SIZE_LIMIT);

        final ByteArrayOutputStreamSource baoss = new ByteArrayOutputStreamSource();
        freeHepAdapter
                .convertEmfToSvg(
                        new UrlInputStreamSource(TestResources.class
                                .getResource("test/emf/png-in-emf.emf")), baoss);

        Assert.assertTrue(baoss.getByteArray().length > 100000);
    }

    @Ignore // ssytnik@: ignored @ 2013-01-29, akirakozov@ should resolve it
    @Test
    public void testConvertBlendingEmfToSvg() {
        FreeHepAdapter freeHepAdapter = new FreeHepAdapter(SIZE_LIMIT);

        freeHepAdapter.convertEmfToSvg(
                new UrlInputStreamSource(TestResources.class.getResource("test/emf/DOCVIEWER-958.emf")),
                new DevNullOutputStreamSource());

    }
}
