package ru.yandex.chemodan.app.docviewer.adapters.imagemagick;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author ssytnik
 */
public class ImageMagickAdapter2Test extends DocviewerSpringTestBase {

    @Autowired
    private ImageMagickAdapter2 imageMagickAdapter2;

    @Test
    public void rotation() {
        InputStreamSource ss = new ClassPathResourceInputStreamSource(TestResources.class, "test/jpg/left.jpg");
        ImageMagickConvertInfo info = imageMagickAdapter2.convert(ss, new DevNullOutputStreamSource(), Option.empty());
        Assert.equals(ImageFormat.JPEG, info.getFormat());
        Assert.equals(Dimension.valueOf(480, 640), info.getSize());
    }

    @Test
    public void convertPsd() {
        InputStreamSource ss = new ClassPathResourceInputStreamSource(TestResources.class, "test/psd/vsn_new_01.psd");
        ImageMagickConvertInfo info = imageMagickAdapter2.convert(ss, new DevNullOutputStreamSource(), Option.of(0));
        Assert.equals(ImageFormat.JPEG, info.getFormat());
        Assert.equals(Dimension.valueOf(1000, 747), info.getSize());
    }

}
