package ru.yandex.chemodan.app.docviewer.adapters.openoffice;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.adapters.AdaptersTestBase;

public class OpenOfficeProcessPoolTest extends AdaptersTestBase {
    private static final int MAX_RETRIES = 1;

    @Autowired
    private OpenOfficeProcessPool commonOOProcessPool;

    @Test
    public void testDoubleConnection() {
        OpenOfficeConnection connection1 = commonOOProcessPool.openConnection(MAX_RETRIES);
        try {
            commonOOProcessPool.openConnection(MAX_RETRIES).disconnect();
        } finally {
            connection1.disconnect();
        }
    }

    @Test
    public void testFindFreePort() {
        int freeport = OpenOfficeProcessFactory.findFreePort();
        Assert.assertTrue(freeport > 0);
    }

    @Test
    public void testSingleConnection() {
        OpenOfficeConnection connection = commonOOProcessPool.openConnection(MAX_RETRIES);
        connection.disconnect();
    }
}
