package ru.yandex.chemodan.app.docviewer.convert;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.AbstractSpringAwareTest;
import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.states.State;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.test.Assert;

@RunWith(value = Parameterized.class)
public class ConvertManagerTestSuite extends AbstractSpringAwareTest {

    private static final Logger logger = LoggerFactory.getLogger(ConvertManagerTestSuite.class);

    @Autowired
    private TestManager testManager;

    @Parameters
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<>();

        for (TargetType targetType : new TargetType[] { TargetType.HTML_ONLY, TargetType.PDF,
                TargetType.PLAIN_TEXT })
        {
            for (URL url : new URL[] { TestResources.Adobe_Acrobat_1_3_001p, //
                    TestResources.Adobe_Acrobat_1_4_001p_limited, //
                    TestResources.Adobe_Acrobat_1_4_004p, //
                    TestResources.Adobe_Acrobat_1_5_114p, //
            })
            {
                data.add(new Object[] { url, targetType, State.AVAILABLE });
            }
            data.add(new Object[] { TestResources.Adobe_Acrobat_1_4_001p_password, targetType,
                    State.CONVERTING_ERROR });
        }

        for (URL url : new URL[] {
                //
//                TestResources.Adobe_Photoshop_CS2, //
//                TestResources.Adobe_Photoshop_CS5, //
//                TestResources.Adobe_Illustrator_1199x651, //
//                TestResources.Corel_Draw, //
                TestResources.JPEG, //
                TestResources.Microsoft_BMP_200x200, //
                TestResources.Microsoft_PowerPoint_97_001p, //
                TestResources.Microsoft_PowerPoint_12_043p, //
//                TestResources.Nikon_D300, //
                TestResources.OpenOffice_Impress_3_3_001p, //
                TestResources.SVG, //
        //
        })
        {
//            data.add(new Object[] { url, TargetType.PDF, State.AVAILABLE });
            data.add(new Object[] { url, TargetType.HTML_WITH_IMAGES, State.AVAILABLE });
        }

        for (URL url : new URL[] {
                //
                TestResources.Microsoft_RTF, //
                TestResources.OpenOffice_Calc_3_0_001p, //
                TestResources.OpenOffice_Writer_3_2_001p, //
        })
        {
            data.add(new Object[] { url, TargetType.PDF, State.AVAILABLE });
        }

        for (URL url : new URL[] {
                //
                TestResources.Microsoft_Excel_97_001p, //
                TestResources.Microsoft_Excel_97_003p, //
                TestResources.Microsoft_SpreadsheetML, //
                TestResources.Microsoft_Word_12_001p, //
                TestResources.Microsoft_Word_12_Template, //
                TestResources.Microsoft_Word_95_001p, //
                TestResources.Microsoft_WordML, //
                TestResources.CSV_Comma_utf_8, //
                TestResources.CSV_Comma_windows_1251, //
        })
        {
            data.add(new Object[] { url, TargetType.HTML_ONLY, State.AVAILABLE });
            data.add(new Object[] { url, TargetType.HTML_WITH_IMAGES, State.AVAILABLE });
            data.add(new Object[] { url, TargetType.PDF, State.AVAILABLE });
        }

        data.add(new Object[] { TestResources.HTML, TargetType.PDF, State.CONVERTING_ERROR });

        // TODO handle this
//        data.add(new Object[] { TestResources.Apache_Poi_Examples_Documents, TargetType.PLAIN_TEXT,
//                State.ARCHIVE });
//        data.add(new Object[] { TestResources.Apache_Poi_Examples_Spreadsheets,
//                TargetType.PLAIN_TEXT, State.ARCHIVE });

        return data;
    }

    private final TargetType convertTargetType;

    private final State resultState;

    private final URL source;

    public ConvertManagerTestSuite(final URL source, final TargetType convertTargetType, final State resultState) {
        this.source = source;
        this.convertTargetType = convertTargetType;
        this.resultState = resultState;
    }

    @Test
//    @Ignore
    public void test() {
        logger.info("About to process {}, {}", source, convertTargetType);
        final State finalState = testManager.waitUriToComplete(
                PassportUidOrZero.zero(), UriUtils.toUrlString(source), convertTargetType);

        Assert.A.equals(resultState, finalState);
    }
}
