package ru.yandex.chemodan.app.docviewer.convert;

import java.util.List;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.convert.openoffice.OpenOfficeConverter;
import ru.yandex.chemodan.app.docviewer.convert.xls.XlsConverter;
import ru.yandex.misc.test.Assert;

public class ConverterRepositoryTest extends DocviewerSpringTestBase {

    @Autowired
    private ConvertManager convertManager;

    @Test
    public void testExcel() {
        List<Converter> converters = convertManager.getConverters().get(MimeTypes.MIME_MICROSOFT_EXCEL);

        Assert.assertEquals(2, converters.size());
        Assert.assertTrue(converters.get(0) instanceof XlsConverter);
        Assert.assertTrue(converters.get(1) instanceof OpenOfficeConverter);
    }

}
