package ru.yandex.chemodan.app.docviewer.convert;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.AbstractSpringAwareTest;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.misc.io.url.UrlInputStreamSource;

@RunWith(Parameterized.class)
public class MimeDetectorSuiteTest extends AbstractSpringAwareTest {

    @Parameters
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<>();

        data.add(new Object[] { MimeTypes.MIME_PDF, TestResources.Adobe_Acrobat_1_3_001p });
        data.add(new Object[] { MimeTypes.MIME_PDF,
                TestResources.Adobe_Acrobat_1_4_001p_limited });
        data.add(new Object[] { MimeTypes.MIME_PDF,
                TestResources.Adobe_Acrobat_1_4_001p_password });
        data.add(new Object[] { MimeTypes.MIME_PDF, TestResources.Adobe_Acrobat_1_4_004p });
        data.add(new Object[] { MimeTypes.MIME_PDF, TestResources.Adobe_Acrobat_1_5_114p });

        data.add(new Object[] { MimeTypes.MIME_ADOBE_POSTSCRIPT,
                TestResources.Adobe_Illustrator_1199x651 });

        data.add(new Object[] { MimeTypes.MIME_ADOBE_PHOTOSHOP, TestResources.Adobe_Photoshop_CS2 });
        data.add(new Object[] { MimeTypes.MIME_ADOBE_PHOTOSHOP, TestResources.Adobe_Photoshop_CS5 });

        data.add(new Object[] { MimeTypes.MIME_ARCHIVE_ZIP,
                TestResources.Apache_Poi_Examples_Documents });
        data.add(new Object[] { MimeTypes.MIME_ARCHIVE_ZIP,
                TestResources.Apache_Poi_Examples_Spreadsheets });

//        data.add(new Object[] { MimeTypes.MIME_COREL_DRAW, TestResources.Corel_Draw });
        data.add(new Object[] { MimeTypes.MIME_HTML, TestResources.HTML });
        data.add(new Object[] { MimeTypes.MIME_IMAGE_JPEG, TestResources.JPEG });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_EMF, TestResources.Microsoft_EMF });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_EXCEL,
                TestResources.Microsoft_Excel_97_001p });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_POWERPOINT,
                TestResources.Microsoft_PowerPoint_97_001p });
        data.add(new Object[] { MimeTypes.MIME_RTF, TestResources.Microsoft_RTF });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_SPREADSHEETML,
                TestResources.Microsoft_SpreadsheetML });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WMF, TestResources.Microsoft_WMF_delta });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_WORD,
                TestResources.Microsoft_Word_12_001p });
        // DOCVIEWER-926
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_WORD,
                TestResources.Microsoft_Word_12_MIME });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_WORD_TEMPLATE,
                TestResources.Microsoft_Word_12_Template });

        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT,
                TestResources.Microsoft_PowerPoint_12_043p });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT,
                TestResources.Microsoft_PowerPoint_Docviewer_933 });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT,
                TestResources.Microsoft_PowerPoint_Docviewer_1269 });

        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WORD, TestResources.Microsoft_Word_95_001p });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WORD,
                TestResources.Microsoft_Word_97_001p_password });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WORD, TestResources.Microsoft_Word_97_046p });
        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WORD, TestResources.Microsoft_Word_97_102p });

        data.add(new Object[] { MimeTypes.MIME_MICROSOFT_WORDML, TestResources.Microsoft_WordML });
        data.add(new Object[] { MimeTypes.MIME_IMAGE_TIFF, TestResources.Nikon_D300 });
        data.add(new Object[] { MimeTypes.MIME_OPENDOCUMENT_SPREADSHEET,
                TestResources.OpenOffice_Calc_3_0_001p });
        data.add(new Object[] { MimeTypes.MIME_OPENDOCUMENT_PRESENTATION,
                TestResources.OpenOffice_Impress_3_3_001p });
        data.add(new Object[] { MimeTypes.MIME_OPENDOCUMENT_TEXT,
                TestResources.OpenOffice_Writer_3_2_001p });
        data.add(new Object[] { MimeTypes.MIME_IMAGE_SVG, TestResources.SVG });
        data.add(new Object[] { MimeTypes.MIME_IMAGE_TIFF, TestResources.TIFF });

        data.add(new Object[] { MimeTypes.MIME_FB2, TestResources.FB2_EXAMPLE });
        data.add(new Object[] { MimeTypes.MIME_EPUB, TestResources.EPUB });
        data.add(new Object[] { MimeTypes.MIME_EPUB, TestResources.EPUB2 });

        data.add(new Object[] { MimeTypes.IMAGE_X_IMAGEMAGICK_SUPPORTED, TestResources.ICO });

        return data;
    }

    private final String expectedMimeType;

    @Autowired
    private MimeDetector mimeDetector;

    private final URL source;

    public MimeDetectorSuiteTest(String expectedMimeType, URL source) {
        this.expectedMimeType = expectedMimeType;
        this.source = source;
    }

    @Test
    public void test() {
        String actual = mimeDetector.getMimeType(new UrlInputStreamSource(source));
        Assert.assertEquals(expectedMimeType, actual);
    }

}
