package ru.yandex.chemodan.app.docviewer.convert;

import java.net.URI;

import org.junit.Test;

import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.test.Assert;

public class MimeDetectorTest {

    @Test
    public void smoke() {
        MimeDetector detector = new MimeDetector();
        Assert.equals("text/plain", detector.getMimeTypeByFilename("a.txt"));
        Assert.equals("application/msword", detector.getMimeTypeByFilename("b.doc"));
    }

    @Test
    public void letterCase() {
        MimeDetector detector = new MimeDetector();
        Assert.equals("application/msword", detector.getMimeTypeByFilename("B.DOC"));
    }

    @Test
    public void letterCaseMime() {
        Assert.equals(true, MimeDetector.isArchive(MimeTypes.ARCHIVE_X_SEVENZIP_SUPPORTED));
    }


    @Test
    public void testGetMimeTypeByUri() {
        String docviewerUrl = "https://docviewer.yandex-team.ru/"
                + "?url=http%3A%2F%2Fwebattach.mail.yandex.net"
                + "%2Fmessage_part_real"
                + "%2Fabook_MO_ru.csv"
                + "%3Fsid%3Djwh6%252A56luld1GvO%252AmZ9xkJ8xvAz3JcugeL8PkkcuTbVGy7Rc6vkIUFo4Taulz%252AJve3Fv3XF2wV1fFS95i%252Ae9aWkzvQrQlaLM";
        String webattachUrl = UrlUtils.getQueryParameterFromUrl(docviewerUrl, "url").get();
        URI webattachUri = UriUtils.urlToUri(webattachUrl);
        String detectedType = new MimeDetector().getMimeTypeByUri(webattachUri);
        Assert.equals(MimeTypes.MIME_CSV, detectedType);
    }
}
