package ru.yandex.chemodan.app.docviewer.convert.book;

import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class BookCoverCreaterTest extends DocviewerSpringTestBase {

    @Autowired
    private BookCoverCreater bookCoverCreater;

    @Test
    public void createCover() throws IOException {
        // just check, that cover creation not fails
        File2 result = bookCoverCreater.createCover("Лев Николаевич Толстой", "Война и мир");
        try {
            BufferedImage img = ImageIO.read(result.getFile());
            Assert.equals(img.getWidth(), 266);
            Assert.equals(img.getHeight(), 362);
        } finally {
            result.deleteRecursiveQuietly();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailBecauseOfEmptyAuthorAndTitle() {
        bookCoverCreater.createCover("", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailBecauseOfBlankAuthorAndTitle() {
        bookCoverCreater.createCover(" ", "\n");
    }

}
