package ru.yandex.chemodan.app.docviewer.convert.djvu;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.PdfToHtmlWrapper;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.chemodan.app.docviewer.web.DocviewerWebSpringTestBase;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

public class DjvuConverterTest extends DocviewerWebSpringTestBase {

    @Autowired
    private ConvertManager convertManager;

    @Autowired
    @Qualifier("wrappedDjvuConverter")
    private PdfToHtmlWrapper wrappedDjvuConverter;

    @Test
    public void testScriptNotFail() {
        DjvuConverter dc = new DjvuConverter();
        dc.doConvert(new UrlInputStreamSource(TestResources.DJVU_EXAMPLE), "any",
                TargetType.PDF, new DevNullOutputStreamSource(), Option.empty());
    }

    @Test
    public void testPdfPageCount() {
        ConvertResultInfo convertResult = convertDjvu(TargetType.PDF);
        Assert.equals(convertResult.getPages(), 36);
    }

    @Test
    public void testHtmlPageCount() {
        ConvertResultInfo convertResult = convertDjvu(TargetType.HTML_WITH_IMAGES);
        Assert.equals(convertResult.getPages(), 36);
    }

    @Test
    public void testPreview() {
        ConvertResultInfo convertResult = convertDjvu(TargetType.PREVIEW);
        Assert.equals(convertResult.getPages(), 1);
    }

    public ConvertResultInfo convertDjvu(TargetType type) {
        ConvertResultInfo result = convertManager.convertCommon(
                new UrlInputStreamSource(TestResources.DJVU_EXAMPLE),
                "image/vnd.djvu",
                wrappedDjvuConverter,
                type, new DevNullOutputStreamSource());
        return result;
    }
}
