package ru.yandex.chemodan.app.docviewer.convert.doc;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.AbstractSpringAwareTest;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestSuites;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;

@RunWith(Parameterized.class)
public class DocConverterSimpleTestSuite extends AbstractSpringAwareTest {

    private static final Logger logger = LoggerFactory.getLogger(DocConverterSimpleTestSuite.class);

    @Parameters
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<>();
        for (URL resource : TestSuites.MICROSOFT_WORD_97) {
            data.add(new Object[] { resource, TargetType.HTML_ONLY });
            data.add(new Object[] { resource, TargetType.HTML_WITH_IMAGES });
//            data.add(new Object[] { resource, TargetType.PDF });
            data.add(new Object[] { resource, TargetType.PLAIN_TEXT });
        }
        return data;
    }

    @Autowired
    private ConvertManager convertManager;

    private final TargetType convertTargetType;

    @Autowired
    private DocConverter docConverter;

    private final URL document;

    public DocConverterSimpleTestSuite(URL document, TargetType convertTargetType) {
        this.document = document;
        this.convertTargetType = convertTargetType;
    }

    @Test
    public void testConvert() {
        logger.info("Processing document: {} to {}", document, convertTargetType);
        convertManager.convertCommon(new UrlInputStreamSource(document), MimeTypes.MIME_MICROSOFT_WORD,
                docConverter, convertTargetType, new DevNullOutputStreamSource());
    }

}
