package ru.yandex.chemodan.app.docviewer.convert.doc;

import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

public class DocConverterTest extends DocviewerSpringTestBase {

    @Autowired
    private ConvertManager convertManager;

    private static final TargetType CONVERT_TARGET_TYPE = TargetType.HTML_WITH_IMAGES;

    @Autowired
    private DocConverter docConverter;

    @Test
    public void test_Microsoft_Word_97_001p() {
        convertManager.convertCommon(new UrlInputStreamSource(TestResources.Microsoft_Word_97_001p),
                MimeTypes.MIME_MICROSOFT_WORD, docConverter, CONVERT_TARGET_TYPE,
                new DevNullOutputStreamSource());
    }

    @Test
    public void test_Microsoft_Word_97_001p_password_exception() {
        try {
            convertManager.convertCommon(new UrlInputStreamSource(
                    TestResources.Microsoft_Word_97_001p_password), MimeTypes.MIME_MICROSOFT_WORD,
                    docConverter, CONVERT_TARGET_TYPE, new DevNullOutputStreamSource());
            Assert.A.fail("UserException expected");
        } catch (UserException exc) {
            Assert.A.equals(ErrorCode.UNSUPPORTED_PASSWORD_PROTECTED, exc.getErrorCode());
        }
    }

    @Ignore // DocConverter#loadDoc
    @Test
    public void test_Microsoft_Word_97_001p_password_extract() {
        convertManager.convertCommon(new UrlInputStreamSource(
                TestResources.Microsoft_Word_97_001p_password), MimeTypes.MIME_MICROSOFT_WORD,
                docConverter, CONVERT_TARGET_TYPE, new DevNullOutputStreamSource(),
                Option.of("password"));
    }
}
