package ru.yandex.chemodan.app.docviewer.convert.doc;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;

public class DocxConverterTest extends DocviewerSpringTestBase {

    private static final TargetType CONVERT_TARGET_TYPE = TargetType.PDF;
    @Autowired
    private ConvertManager convertManager;
    @Autowired
    private DocxConverter docConverter;

    @Test
    public void test_Microsoft_Word_Docx() {
        convertManager.convertCommon(new UrlInputStreamSource(
                        TestResources.Microsoft_Word_12_017p), MimeTypes.MIME_MICROSOFT_WORD,
                docConverter, CONVERT_TARGET_TYPE, new DevNullOutputStreamSource(),
                Option.empty());
    }
}
