package ru.yandex.chemodan.app.docviewer.convert.epub;

import java.net.URL;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class EpubConverterTest extends DocviewerSpringTestBase {

    @Autowired
    private EpubConverter epubConverter;

    @Autowired
    private TestManager testManager;


    private void checkPartsCount(URL epubUrl, final int partsCount) {
        FileUtils.withZipFile(new UrlInputStreamSource(epubUrl), epubFile -> {
            ListF<String> parts = EpubConverter.getOrderedParts(EpubConverter.OpfFileInfo.create(epubFile));
            Assert.hasSize(partsCount, parts);
        });
    }

    @Test
    public void getOrderedParts() {
        checkPartsCount(TestResources.EPUB, 35);
    }

    @Test
    public void getOrderedParts2() {
        checkPartsCount(TestResources.EPUB2, 1);
    }

    @Test
    public void convert() {
        FileUtils.withEmptyTemporaryFile("epub-result", ".zip", f -> {
            epubConverter.convert(new UrlInputStreamSource(TestResources.EPUB), MimeTypes.MIME_EPUB,
                    TargetType.HTML_WITH_IMAGES, f.asOutputStreamTool(), Option.empty());
            Assert.lt(0L, f.lengthO().get());
        });
    }

    @Test
    public void convertDocviewer1332() {
        // File contains tags with the same attribute, but with different prefixes:
        // lang="en" and xml:lang="en"
        FileUtils.withEmptyTemporaryFile("epub-result", ".zip", f -> {
            epubConverter.convert(new UrlInputStreamSource(TestResources.EPUB_DOCVIEWER_1332), MimeTypes.MIME_EPUB,
                    TargetType.HTML_WITH_IMAGES, f.asOutputStreamTool(), Option.empty());
            Assert.lt(0L, f.lengthO().get());
        });
    }

    @Test
    public void convertPreviewByCoverpageImage() {
        FileUtils.withEmptyTemporaryFile("epub-preview", ".zip", f -> {
            epubConverter.convert(new UrlInputStreamSource(TestResources.EPUB), MimeTypes.MIME_EPUB,
                    TargetType.PREVIEW, f.asOutputStreamTool(), Option.empty());
            Assert.lt(0L, f.lengthO().get());
        });
    }

    @Test
    public void convertPreviewByTitleInfo() {
        FileUtils.withEmptyTemporaryFile("epub-preview", ".zip", f -> {
            epubConverter.convert(new UrlInputStreamSource(TestResources.EPUB2), MimeTypes.MIME_EPUB,
                    TargetType.PREVIEW, f.asOutputStreamTool(), Option.empty());
            Assert.lt(0L, f.lengthO().get());
        });
    }

    @Test
    public void copyAndConvert() {
        testManager.makeAvailable(
                PassportUidOrZero.zero(),
                TestResources.EPUB,
                TargetType.HTML_WITH_IMAGES);
    }

}
