package ru.yandex.chemodan.app.docviewer.convert.fb2;

import java.util.zip.ZipEntry;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.ZipEntryInputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author ssytnik
 */
public class Fb2ConverterTest extends DocviewerSpringTestBase {

    @Autowired
    private Fb2Converter fb2Converter;


    @Test
    public void convert() {
        FileUtils.withEmptyTemporaryFile("fb2-result", ".zip", f -> {
            fb2Converter.convert(new UrlInputStreamSource(TestResources.FB2_EXAMPLE), MimeTypes.MIME_FB2,
                    TargetType.HTML_WITH_IMAGES, f.asOutputStreamTool(), Option.empty());
            FileUtils.withZipFile(f, a -> {
                Assert.isNull(a.getEntry("invalid-entry"));
                for (String entryName : Cf.list("cover.jpg", "tolstoy_port.jpg", "page_1.xml")) {
                    Assert.notNull(a.getEntry(entryName), "Should be not null: " + entryName);
                }

                // this actually depends on fix-extensions property, but real books should have correct filenames
                Assert.assertContains(
                        new ZipEntryInputStreamSource(a, new ZipEntry("page_1.xml")).readText(),
                        "tolstoy_port.jpg");
            });
        });
    }

    @Test
    public void convertPreviewByCoverpageImage() {
        FileUtils.withEmptyTemporaryFile("fb2-preview", ".zip", f -> {
            fb2Converter.convert(new UrlInputStreamSource(TestResources.FB2_EXAMPLE), MimeTypes.MIME_FB2,
                    TargetType.PREVIEW, f.asOutputStreamTool(), Option.empty());
            Assert.lt(0L, f.lengthO().get());
        });
    }

    // TODO convertPreviewByTitleInfo test

}
