package ru.yandex.chemodan.app.docviewer.convert.imagemagic;

import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.PageInfo;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResultDao;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.test.Assert;

public class ImageMagickConverterTest extends DocviewerSpringTestBase {

    @Autowired
    private StoredResultDao storedResultDao;

    @Autowired
    private TestManager testManager;

    @Test
    @Ignore
    public void test_Adobe_Photoshop_CS2() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(),
                TestResources.Adobe_Photoshop_CS2, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES).get()
                .getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(400f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(400f, pageInfo.getHeight().get().floatValue());
    }

    @Test
    @Ignore
    public void test_Adobe_Photoshop_CS5() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Adobe_Photoshop_CS5, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(400f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(400f, pageInfo.getHeight().get().floatValue());
    }

    @Test
    @Ignore
    public void test_Adobe_Photoshop_XMP_4layers() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Adobe_Photoshop_XMP_2_8_2_4layers, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(203f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(118f, pageInfo.getHeight().get().floatValue());
    }

    @Test
    @Ignore
    public void test_Adobe_Photoshop_XMP_5layers() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Adobe_Photoshop_XMP_2_8_2_5layers, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(203f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(118f, pageInfo.getHeight().get().floatValue());
    }

    @Test
    public void test_BMP_127x64() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Microsoft_BMP_127x64, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(127f, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(64f, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    public void test_BMP_200x200() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Microsoft_BMP_200x200, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(200f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(200f, pageInfo.getHeight().get().floatValue());
    }

    @Test
    public void test_BMP_256x256() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.Microsoft_BMP_512x512, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(512f, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(512f, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    public void test_JPEG() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), TestResources.JPEG, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(400, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(400, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    @Ignore("Problems in imagemagick, ufraw-batch is missing. ssytnik@: I believe in some circumstances it could pass without this lib")
    public void test_Nikon_D300() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Nikon_D300), TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(4320f, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(2868f, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    public void test_PNG_1000x1080() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.PNG_1000x1080, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(948, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(1024, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    public void test_PNG_134x157() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.PNG_134x157, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(134, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(157, Math.round(pageInfo.getHeight().get()));
    }

    // Digging:
    // PagesInfoHelper.toPagesInfo(PDDocument): page 1:
    // Media box = [0.0,0.0,354.148,375.907] (float values), however there is
    // Resources/XObject/Im0/baseObject/{COSName{Width}=COSInt{472} COSName{Height}=COSInt{501}}
    //
    // In test_PNG_134x157 that passes, media box corresponds to Width and Height values.
    //
    // Reproduces:
    // ubuntu 12.04: imagemagick 8:6.6.9.7-5ubuntu3.2 and 8:6.7.7.10-2ubuntu4
    // RHEL 6.3: ImageMagick.x86_64 6.5.4.7-6.el6_2
    @Test
    @Ignore("Problems in imagemagick")
    public void test_PNG_472x501() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.PNG_472x501, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(472, Math.round(pageInfo.getWidth().get()));
        Assert.assertEquals(501, Math.round(pageInfo.getHeight().get()));
    }

    @Test
    public void test_SVG() {
        String fileId = testManager.makeAvailable(
                PassportUidOrZero.zero(), TestResources.SVG, TargetType.HTML_WITH_IMAGES);

        PageInfo pageInfo = storedResultDao.find(fileId, TargetType.HTML_WITH_IMAGES)
                .get().getPagesInfo().get().getPageInfos().get(0);
        Assert.assertEquals(709f, pageInfo.getWidth().get().floatValue());
        Assert.assertEquals(567f, pageInfo.getHeight().get().floatValue());
    }

    // TODO test_CR2

}
