package ru.yandex.chemodan.app.docviewer.convert.openoffice;

import java.io.File;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.AbstractSpringAwareTest;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.MimeDetector;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.file.FileInputStreamSource;

@RunWith(value = Parameterized.class)
public class PoiExamplesTestSuite extends AbstractSpringAwareTest {

    private static final File resultsDirectory = new File(
            ru.yandex.chemodan.app.docviewer.convert.doc.PoiExamplesTestSuite.PATH_TEST_RESULTS);

    @BeforeClass
    public static void beforeClass() {
        ru.yandex.chemodan.app.docviewer.convert.doc.PoiExamplesTestSuite.beforeClass();
    }

    @Parameters
    public static Collection<Object[]> data() {
        return ru.yandex.chemodan.app.docviewer.convert.doc.PoiExamplesTestSuite.data();
    }

    @Autowired
    private ConvertManager convertManager;

    private final String entryName;

    @Autowired
    private MimeDetector mimeDetector;

    @Autowired
    private OpenOfficeConverter openOfficeConverter;

    public PoiExamplesTestSuite(String entryName) {
        this.entryName = entryName;
    }

    @Test
    public void test() {
        final File inputFile = new File(resultsDirectory, entryName);

        final InputStreamSource source = new FileInputStreamSource(inputFile);
        final String mimeType = mimeDetector.getMimeType(source);

        convertManager.convertCommon(source, mimeType, openOfficeConverter, TargetType.PDF,
                new DevNullOutputStreamSource());
    }

}
