package ru.yandex.chemodan.app.docviewer.convert.pdf;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.junit.Test;

import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.utils.pdf.PdfUtils;
import ru.yandex.misc.io.IoFunction1V;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

public class PdfTextStripperImplTest {

    @Test
    public void testCharsOnPictures() throws Exception {
        final List<String> foundStrings = new ArrayList<>();
        final AbstractPdfTextStripper textStripper = new AbstractPdfTextStripper() {
            protected void
                    writeLine(ColoredTextPosition formatHolder, float x, float y, String text)
            {
                foundStrings.add(text);
            }
        };
        textStripper.setStartPage(17);
        textStripper.setEndPage(17);

        PdfUtils.withExistingDocument(
                new UrlInputStreamSource(TestResources.Adobe_Acrobat_1_5_114p), true,
                (IoFunction1V<PDDocument>) document -> {
                    textStripper.writeText(document, new StringWriter());
                });

        // found only on picture
        Assert.assertFalse(foundStrings.contains("T"));
        Assert.assertFalse(foundStrings.contains("W"));
        Assert.assertFalse(foundStrings.contains("Z"));

        // found in text
        Assert.assertTrue(foundStrings.contains("iterative"));
        Assert.assertTrue(foundStrings.contains("algorithm"));
    }
}
