package ru.yandex.chemodan.app.docviewer.convert.pdf;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.chemodan.app.docviewer.web.DocviewerWebSpringTestBase;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

public class PdfToHtmlTest extends DocviewerWebSpringTestBase {

    @Autowired
    private TestManager testManager;

    @Test
    public void testCropbox() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Adobe_Acrobat_1_4_001p_cropbox), TargetType.HTML_WITH_IMAGES);

        String htmlPageInfo = ApacheHttpClientUtils
                .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0&id=" + fileId
                        + "&page=1");

        Assert.assertContains(htmlPageInfo, ".pw1{width:1024px;} .ph1{height:769px;}");
    }

    @Test
    public void testLandscape() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Adobe_Acrobat_1_4_004p_landscape), TargetType.HTML_WITH_IMAGES);

        String htmlPageInfo = ApacheHttpClientUtils
                .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0&id=" + fileId
                        + "&page=1");

        Assert.assertContains(htmlPageInfo, ".pw1{width:1024px;} .ph1{height:724px;}");
    }

    @Test
    public void testJeanPdf() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Adobe_Acrobat_jean), TargetType.HTML_WITH_IMAGES);

        // just test, that file was converted,
        // https://jira.yandex-team.ru/browse/DOCVIEWER-338
        ApacheHttpClientUtils.downloadString(
                "http://localhost:32405/htmlwithimagespageinfo?uid=0&id=" + fileId + "&page=1");
    }

    @Test
    public void testDocviewer963() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(),
                UriUtils.toUrlString(TestResources.class.getResource("test/pdf/DOCVIEWER-963.pdf")),
                TargetType.HTML_WITH_IMAGES);

        // just test, that file was converted,
        ApacheHttpClientUtils.downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0&id=" + fileId + "&page=1");
    }
}
