package ru.yandex.chemodan.app.docviewer.convert.pdf.fonts;

import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.misc.test.Assert;
import ru.yandex.misc.time.TimeUtils;

public class FontNameParserTest {

    @Test
    public void cannotParse() {
        Assert.isFalse(FontNameParser.parse("[none]").isPresent());
    }

    @Ignore
    @Test
    public void perfTest() {
        String[] frequentFontNames = new String[] {
                "Times", "Arial", "ArialMT", "Helvetica",
                "TimesNewRomanPSMT", "Times-Roman", "CenturyGothic", "Arial,Bold",
                "TimesNewRoman", "GCOCZM+TimesNewRomanPSMT", "TimesNewRomanPS-BoldMT", //"[none]",
                "Symbol", "Arial-BoldMT", "Helvetica-Bold", "Times-Italic", "Courier",
                "Times-Bold", "TimesNewRoman,Bold", "ABCDEE+Arial"
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < 20000; ++i) {
            for (String pdfFontName : frequentFontNames) {
                FontNameParser.parse(pdfFontName);
            }
        }
        System.out.println(TimeUtils.toSecondsString(TimeUtils.toDurationToNow(start)));
    }

}
