package ru.yandex.chemodan.app.docviewer.convert.presentations;

import java.awt.image.RenderedImage;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.Converter;
import ru.yandex.chemodan.app.docviewer.convert.MimeDetector;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.ImageUtils;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfRenderTargetTypeHolder;
import ru.yandex.chemodan.app.docviewer.web.DocviewerWebSpringTestBase;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.io.IoFunction1V;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.file.FileOutputStreamSource;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

public class PresentationConverterTest extends DocviewerWebSpringTestBase {

    @Autowired
    private TestManager testManager;

    @Autowired
    @Qualifier("wrappedPresentationConverter")
    private Converter converter;

    @Autowired
    private ConvertManager convertManager;

    @Autowired
    private MimeDetector mimeDetector;

    @Autowired
    PdfRenderTargetTypeHolder pdfRenderTargetTypeHolder;

    @Test
    public void testContentIsPdf() {
        FileUtils.withEmptyTemporaryFile("presentation", ".pdf", (IoFunction1V<File2>) tempFile -> {
            convertManager.convertCommon(new UrlInputStreamSource(
                    TestResources.Microsoft_PowerPoint_97_001p),
                    MimeTypes.MIME_MICROSOFT_POWERPOINT, converter,
                    TargetType.HTML_WITH_IMAGES, new FileOutputStreamSource(tempFile));

            Assert.A.equals(MimeTypes.MIME_PDF, mimeDetector.getMimeType(tempFile));
        });
    }

    @Test
    public void testHttpResponses() {
        String ext = pdfRenderTargetTypeHolder.getTargetType().value();
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Microsoft_PowerPoint_97_001p), TargetType.HTML_WITH_IMAGES);

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0" + "&id="
                            + fileId + "&page=1&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-0." + ext);
        }

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagesinfo?uid=0" + "&id="
                            + fileId + "&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-0." + ext);
        }

        {
            byte[] result = ApacheHttpClientUtils.download("http://localhost:32405/htmlimage" + "?uid=0&id=" + fileId
                    + "&width=2048&name=bg-0." + ext);
            RenderedImage image = ImageUtils.read(new ByteArrayInputStreamSource(result));
            Assert.assertEquals(2048, image.getWidth());
            Assert.assertEquals(1536, image.getHeight());
        }

    }

    @Test
    public void testHttpResponses_Multipage() {
        String ext = pdfRenderTargetTypeHolder.getTargetType().value();
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.Microsoft_PowerPoint_97_003p), TargetType.HTML_WITH_IMAGES);

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0" + "&id="
                            + fileId + "&page=1&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-0." + ext);
        }

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0" + "&id="
                            + fileId + "&page=2&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-1." + ext);
        }

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagespageinfo?uid=0" + "&id="
                            + fileId + "&page=3&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-2." + ext);
        }

        {
            String resultString = ApacheHttpClientUtils
                    .downloadString("http://localhost:32405/htmlwithimagesinfo?uid=0" + "&id="
                            + fileId + "&width=2048");
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-0." + ext);
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-1." + ext);
            Assert.assertContains(resultString, "./htmlimage?id=" + fileId
                    + "&amp;width=2048&amp;name=bg-2." + ext);
        }

        {
            byte[] result = ApacheHttpClientUtils.download("http://localhost:32405/htmlimage" + "?uid=0&id=" + fileId
                    + "&width=2048&name=bg-0." + ext);
            RenderedImage image = ImageUtils.read(new ByteArrayInputStreamSource(result));
            Assert.assertEquals(2048, image.getWidth());
            Assert.assertEquals(1536, image.getHeight());
        }

    }

}
