package ru.yandex.chemodan.app.docviewer.convert.result;

import org.junit.Test;

import ru.yandex.chemodan.app.docviewer.convert.DocumentProperties;
import ru.yandex.misc.test.Assert;

public class ConvertResultInfoTest {

    @Test(expected = NullPointerException.class)
    public void testMissedValue() {
        ConvertResultInfo.builder().build();
    }

    @Test
    public void testDefaultValue() {
        ConvertResultInfo convertResultInfo = ConvertResultInfo.builder().type(ConvertResultType.PDF).build();

        Assert.notNull(convertResultInfo.getPagesInfo(), "Default value is null");
        Assert.notNull(convertResultInfo.getImages(), "Default value is null");
        Assert.equals(convertResultInfo.getPages(), 1, "Default value should be 1");
        Assert.equals(convertResultInfo.getProperties(), DocumentProperties.EMPTY);
    }

    @Test
    public void testToBuilder() {
        ConvertResultInfo convertResultInfo = ConvertResultInfo.builder().type(ConvertResultType.PDF).build();
        DocumentProperties documentProperties = DocumentProperties.EMPTY.withProperty("key", "value");

        ConvertResultInfo convertResultInfoUpdated = convertResultInfo.withPropertiesAdded(documentProperties);

        Assert.equals(convertResultInfoUpdated.getType(), ConvertResultType.PDF, "toBuilder does not copy all values");
        Assert.equals(convertResultInfoUpdated.getProperties(), documentProperties);
    }

}
