package ru.yandex.chemodan.app.docviewer.convert.text;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.TestManager;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.chemodan.app.docviewer.web.DocviewerWebSpringTestBase;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

public class CsvConverterTest extends DocviewerWebSpringTestBase {

    @Autowired
    private TestManager testManager;

    @Test
    public void testWindows1251() {
        String fileId = testManager.makeAvailable(PassportUidOrZero.zero(), UriUtils.toUrlString(TestResources.CSV_Comma_windows_1251), TargetType.HTML_ONLY);

        String response = ApacheHttpClientUtils.downloadString("http://localhost:32405/htmlonlyinfo?uid=0&id="
                + fileId);
        Assert.assertContains(response, "jekkatest@ya.ru");
        Assert.assertContains(response,
                "\u0424\u0435\u0434\u043E\u0440 \u0413\u043E\u0440\u0431\u0430\u0447\u0435\u0432");
    }
}
