package ru.yandex.chemodan.app.docviewer.convert.xls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.AbstractSpringAwareTest;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;

@RunWith(Parameterized.class)
public class XlsConverterSimpleTestSuite extends AbstractSpringAwareTest {

    @Parameters
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<>();
        for (URL resource : new URL[] {
                //
                TestResources.Microsoft_Excel_97_001p, //
                TestResources.Microsoft_Excel_97_001p_bug, //
                TestResources.Microsoft_Excel_97_003p, //
                TestResources.Microsoft_Excel_97_006p, //
//                Takes a lot of time
//                TestResources.Microsoft_Excel_97_177p, //
//                TestResources.Microsoft_Excel_97_565p, //
//                TestResources.Microsoft_Excel_97_582p, //
        })
        {
            data.add(new Object[] { resource, TargetType.HTML_ONLY });
        }
        return data;
    }

    @Autowired
    private ConvertManager convertManager;

    private final TargetType convertTargetType;

    private final URL document;

    @Autowired
    private XlsConverter xlsConverter;

    public XlsConverterSimpleTestSuite(URL document, TargetType convertTargetType) {
        this.document = document;
        this.convertTargetType = convertTargetType;
    }

    @Test
    public void testConvert() {
        convertManager.convertCommon(new UrlInputStreamSource(document), MimeTypes.MIME_MICROSOFT_EXCEL,
                xlsConverter, convertTargetType, new DevNullOutputStreamSource());
    }
}
