package ru.yandex.chemodan.app.docviewer.convert.xls;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.TestResources;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.misc.io.devnull.DevNullOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author ssytnik
 */
public class XlsConverterTest extends DocviewerSpringTestBase {

    @Autowired
    private ConvertManager convertManager;

    @Autowired
    private XlsConverter xlsConverter;


    @Test
    public void test_Microsoft_Excel_97_password_exception_html() {
        try {
            do_test_Microsoft_Excel_97_password(TargetType.HTML_WITH_IMAGES, false);
            Assert.A.fail("UserException expected");
        } catch (UserException exc) {
            Assert.A.equals(ErrorCode.FILE_IS_PASSWORD_PROTECTED, exc.getErrorCode());
        }
    }

    @Test
    public void test_Microsoft_Excel_97_password_exception_text() {
        try {
            do_test_Microsoft_Excel_97_password(TargetType.PLAIN_TEXT, false);
            Assert.A.fail("UserException expected");
        } catch (UserException exc) {
            Assert.A.equals(ErrorCode.FILE_IS_PASSWORD_PROTECTED, exc.getErrorCode());
        }
    }

    @Test
    public void test_Microsoft_Excel_97_password_extract() {
        do_test_Microsoft_Excel_97_password(TargetType.HTML_WITH_IMAGES, true);
    }


    private void do_test_Microsoft_Excel_97_password(TargetType targetType, boolean withPassword) {
        convertManager.convertCommon(new UrlInputStreamSource(
                TestResources.Microsoft_Excel_97_LO_password), MimeTypes.MIME_MICROSOFT_EXCEL,
                xlsConverter, targetType, new DevNullOutputStreamSource(),
                Option.when(withPassword, "password"));
    }

}
