package ru.yandex.chemodan.app.docviewer.utils.pdf.image;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.docviewer.DocviewerAnnotationTestContextLoader;
import ru.yandex.chemodan.app.docviewer.DocviewerSpringTestBase;
import ru.yandex.chemodan.app.docviewer.adapters.poppler.ResizeOption;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.web.DocviewerWebSpringTestBase;
import ru.yandex.misc.io.file.FileOutputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 * @author ssytnik
 */
@RunWith(Parameterized.class)
@ContextConfiguration(
        classes = {
                DocviewerWebSpringTestBase.SecretKeysConfiguration.class,
        },
        loader = DocviewerAnnotationTestContextLoader.class)
public class PdfRenderCommonTest extends DocviewerSpringTestBase {
    private static final Logger logger = LoggerFactory.getLogger(PdfRenderCommonTest.class);

    @ClassRule
    public static final SpringClassRule scr = new SpringClassRule();
    @Rule
    public final SpringMethodRule smr = new SpringMethodRule();

    @Autowired
    private PdfRenderer pdfRenderer;
    @Autowired
    private PdfRenderTargetTypeHolder pdfRenderTargetTypeHolder;

    private final Resource resource;

    @Parameters
    public static Collection<Object[]> data() throws IOException {
        ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

        String packageSearchPath = "classpath:ru/yandex/chemodan/app/docviewer/test/pdf/**/*.pdf";
        ListF<Object[]> params = Cf.arrayList();
        for (Resource resource : resourcePatternResolver.getResources(packageSearchPath)) {
            // XXX turn falling test off until ImageMagick version on RedHat becomes >= 6.6.9.7 (now 6.5.4.7)
            if (!resource.getFilename().contains("password") &&
                    !resource.getFilename().equals("e5ebe06b189d35492eb7d55adab6441b.pdf"))
            {
                params.add(new Object[]{resource});
            }
        }
        return params;
    }

    public PdfRenderCommonTest(Resource resource) {
        this.resource = resource;
    }


    @Test
    public void render() throws IOException {
        logger.debug("testing filename = " + resource.getFilename());
        doRender(pdfRenderer, resource.getURL());
    }

    private void doRender(final PdfRenderer pdfRenderer, URL url) {
        final UrlInputStreamSource pdfDocumentSource = new UrlInputStreamSource(url);

        String ext = pdfRenderTargetTypeHolder.getTargetType().value();
        FileUtils.withEmptyTemporaryFile("temp", "." + ext, temporaryPngFile -> {
            pdfRenderer.render(pdfDocumentSource, 1, ResizeOption.scale(DimensionO.WIDTH_900),
                    new FileOutputStreamSource(temporaryPngFile));

            // just check that file was created
            Assert.isTrue(temporaryPngFile.length() > 0);
        });
    }
}
