JAVA_PROGRAM(disk-docviewer)

INCLUDE(${ARCADIA_ROOT}/disk/support/common_header.inc)

LICENSE(Unknown)

OWNER(g:disk-docviewer)

PEERDIR(
    disk/support/common
    disk/support/bazinga
    disk/support/logbroker
    disk/support/ydb-common
    iceberg/misc-mime-detect
    iceberg/commune-mongo
    iceberg/commune-archive
    iceberg/commune-image
    iceberg/inside-mds
    iceberg/inside-bunker
    iceberg/inside-wmi
    iceberg/inside-porto
    yql/library/jdbc

    devtools/jtest

    contrib/java/org/apache/xmlgraphics/fop/2.2
    contrib/java/org/apache/xmlgraphics/xmlgraphics-commons/2.2
    contrib/java/org/apache/xmlgraphics/batik-all/1.9.1

    contrib/java/org/freehep/freehep-graphicsio/2.4
    contrib/java/org/freehep/freehep-graphicsio-emf/2.4
    contrib/java/org/freehep/freehep-graphicsio-svg/2.4
    contrib/java/org/freehep/freehep-graphicsbase/2.4
    contrib/java/org/freehep/freehep-io/2.2.2

    contrib/java/com/artofsolving/jodconverter/2.2.1
    contrib/java/org/openoffice/juh/4.1.2
    contrib/java/org/openoffice/jurt/4.1.2
    contrib/java/org/openoffice/ridl/4.1.2
    contrib/java/org/openoffice/unoil/4.1.2

    contrib/java/org/apache/poi/poi/3.17
    contrib/java/org/apache/poi/poi-scratchpad/3.17
    contrib/java/org/apache/poi/poi-excelant/3.17
    contrib/java/org/apache/poi/poi-ooxml-schemas/3.17
    contrib/java/org/apache/poi/poi-ooxml/3.17

    contrib/java/fr/opensagres/xdocreport/fr.opensagres.xdocreport.converter.docx.xwpf/2.0.1
    contrib/java/fr/opensagres/xdocreport/fr.opensagres.xdocreport.converter.odt.odfdom/2.0.1

    contrib/java/org/apache/pdfbox/pdfbox/1.8.15
    contrib/java/org/apache/pdfbox/fontbox/1.8.15
    contrib/java/org/apache/pdfbox/jempbox/1.8.15

    contrib/java/com/github/dblock/oshi-core/3.3

    contrib/java/net/sourceforge/nekohtml/nekohtml/1.9.22
    contrib/java/com/github/dblock/oshi-core/3.3

    contrib/java/com/google/guava/guava/25.1-android

    contrib/java/net/sf/opencsv/opencsv/2.3
    contrib/java/org/slf4j/jul-to-slf4j

    contrib/java/org/apache/commons/commons-dbcp2/2.2.0
    contrib/java/org/mongodb/mongo-java-driver/2.14.3

    contrib/java/commons-logging/commons-logging/1.2
    contrib/java/junit/junit/4.12

    # JDK10
    contrib/java/javax/xml/bind/jaxb-api/2.3.0

    contrib/java/net/sf/sevenzipjbinding/sevenzipjbinding/16.02-2.01beta
    contrib/java/net/sf/sevenzipjbinding/sevenzipjbinding-all-platforms/16.02-2.01beta
)

INCLUDE(${ARCADIA_ROOT}/disk/support/exclude.inc)
INCLUDE(${ARCADIA_ROOT}/disk/support/lombok.inc)

EXCLUDE(
    contrib/java/org/mongodb/mongodb-driver/3.4.2
    contrib/java/org/mongodb/mongodb-driver/3.10.0

    # replaced by xmlgraphics/batik-all
    contrib/java/org/apache/xmlgraphics/batik-bridge/
    contrib/java/org/apache/xmlgraphics/batik-awt-util/
    contrib/java/org/apache/xmlgraphics/batik-transcoder/
    contrib/java/org/apache/xmlgraphics/batik-ext/
    contrib/java/org/apache/xmlgraphics/batik-gvt/
    contrib/java/org/apache/xmlgraphics/batik-extension/
    contrib/java/org/apache/xmlgraphics/batik-svg-dom/

    contrib/java/net/sf/sevenzipjbinding/sevenzipjbinding/9.20-2.00beta
    contrib/java/net/sf/sevenzipjbinding/sevenzipjbinding-all-platforms/9.20-2.00beta

    contrib/java/com/google/protobuf/protobuf-javalite
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

LINT(base)
END()

RECURSE(
    ut
    src/test
    src/main/java/ru/yandex/chemodan/app/docviewer/cleanup/bazinga/images
    src/main/java/ru/yandex/chemodan/app/docviewer/cleanup/bazinga/documents
)
