package ru.yandex.chemodan.app.stat;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.stat.admin.DiskStatAdminContextConfiguration;
import ru.yandex.chemodan.app.stat.limits.DiskLimitsContextConfiguration;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.log.DiskStatLogReaderContextConfiguration;
import ru.yandex.chemodan.app.stat.storage.DiskStatMongoContextConfiguration;
import ru.yandex.chemodan.app.stat.storage.DownloadStatDao;
import ru.yandex.chemodan.app.stat.storage.SpooledCountryMediatypeStatsWriter;
import ru.yandex.chemodan.app.stat.storage.SpooledPeriodStatsWriter;
import ru.yandex.chemodan.app.stat.storage.StatStorageContextConfiguration;
import ru.yandex.chemodan.app.stat.web.DiskStatWebContextConfiguration;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.commune.script.cosher.server.ScriptTelnetServer;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Lev Tolmachev
 */
@Configuration
@Import({
        DiskStatMongoContextConfiguration.class,
        DiskLimitsContextConfiguration.class,
        StatStorageContextConfiguration.class,
        DiskStatAdminContextConfiguration.class,
        DiskStatLogReaderContextConfiguration.class,
        DiskStatWebContextConfiguration.class
})
public class DiskStatContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DiskStatContextConfiguration.class);

    @Bean
    public DiskStatManager diskStatManager(
            DownloadStatDao downloadStatDao,
            LimitsManager limitsManager,
            SpooledPeriodStatsWriter spooledPeriodStatsWriter,
            SpooledCountryMediatypeStatsWriter mediatypeStats,
            @Value("${check-limits-executor.pool-size}") int poolSize,
            @Value("${check-limits-executor.queue-capacity}") int queueCapacity)
    {
        return new DiskStatManager(downloadStatDao, limitsManager, spooledPeriodStatsWriter, mediatypeStats,
                poolSize, queueCapacity);
    }

    @Bean
    public ScriptTelnetServer scriptTelnetServer(
            @Value("${download-stat.script.telnet.port:-29732}")
            int port)
    {
        return new ScriptTelnetServer(port, true);
    }

    @Bean
    public SingleWarJetty diskStatJetty(
            @Value("${disk-stat.http.port:-28700}") int httpPort,
            @Value("${disk-stat.maxThreads:-1000}") int maxThreads,
            @Value("${disk-stat.http.maxQueueLength:-1000}") int maxQueueLength,
            CoolPingServlet coolPingServlet)
    {
        SingleWarJetty jetty = new SingleWarJetty();
        jetty.setHttpPort(httpPort);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);
        jetty.addFilterMapping("/*", new WtdFilter());
        jetty.addServletMapping("/ping/*", coolPingServlet);

        // kafka send not more than 16Mb at once
        jetty.setMaxFormContentSize((int) DataSize.fromMegaBytes(100).toBytes());
        return jetty;
    }
}
