package ru.yandex.chemodan.app.stat;

import java.util.EnumSet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.stat.log.AntiFoLogListenerManager;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Lev Tolmachev
 */
public class DiskStatMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        new DiskStatMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "download-stat");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                DiskStatContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        Log4jHelper.rootLoggerBuilder().appName(applicationName()).build();
        if (!EnumSet.of(EnvironmentType.PRODUCTION, EnvironmentType.PRESTABLE).contains(EnvironmentType.getActive())) {
            Log4jHelper.configureLogger(AntiFoLogListenerManager.class, Level.TRACE);
        }
    }
}
