package ru.yandex.chemodan.app.stat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Lev Tolmachev
 */
public class TimeUtils {

    public static Instant roundTo(Instant time, Duration period) {
        return time.minus((time.getMillis() + ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE.toTimeZone()
                .getOffset(time.getMillis())) % period.getMillis());
    }

    public static InstantInterval getCurrentPeriod(Duration period) {
        Instant start = roundTo(Instant.now(), period);
        return new InstantInterval(start, start.plus(period));
    }

    public static InstantInterval getPreviousPeriod(InstantInterval period) {
        Duration duration = period.getDuration();
        return new InstantInterval(period.getStart().minus(duration), period.getStart());
    }

    public static InstantInterval getNextPeriod(InstantInterval period) {
        Duration duration = period.getDuration();
        return new InstantInterval(period.getEnd(), period.getEnd().plus(duration));
    }

    public static String intervalToString(InstantInterval interval) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmm");
        format.setTimeZone(ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE.toTimeZone());
        return format.format(interval.getStart().toDate())
                + "_"
                + format.format(interval.getEnd().toDate());
    }

    public static InstantInterval parseInterval(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmm");
        format.setTimeZone(ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE.toTimeZone());

        try {
            Date start = format.parse(str.substring(0, 13));
            Date end = format.parse(str.substring(14));
            return new InstantInterval(new Instant(start), new Instant(end));
        } catch (ParseException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static Function<InstantInterval, String> intervalToStringF() {
        return TimeUtils::intervalToString;
    }
}
