package ru.yandex.chemodan.app.stat;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.misc.test.Assert;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Lev Tolmachev
 */
public class TimeUtilsTest {

    @Test
    public void round() {
        Assert.equals(new Instant("2013-12-22T20:00:00.000Z"),
                TimeUtils.roundTo(new Instant("2013-12-23T09:12:19.318Z"), Duration.standardDays(1)));
    }

    @Test
    public void format() {
        Instant start = new Instant("2013-12-23T00:00:00.000Z");
        Assert.equals("20131223_0400_20131224_0400",
                TimeUtils.intervalToString(new InstantInterval(start, start.plus(Duration.standardDays(1)))));
    }

    @Test
    public void parse() {
        Instant start = new Instant("2013-12-23T00:00:00.000Z");
        InstantInterval interval = new InstantInterval(start, start.plus(Duration.standardDays(1)));

        Assert.equals(interval, TimeUtils.parseInterval(TimeUtils.intervalToString(interval)));
    }

}
