package ru.yandex.chemodan.app.stat.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimits;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimitsRegistry;
import ru.yandex.chemodan.app.stat.web.ConvertToDataSize;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author metal
 */
@ActionContainer
public class AntiPornoLimitsAdminPage {
    private final ChannelLimitsRegistry antiPornoLimitsRegistry;
    private final LimitsManager limitsManager;

    public AntiPornoLimitsAdminPage(ChannelLimitsRegistry antiPornoLimitsRegistry, LimitsManager limitsManager) {
        this.antiPornoLimitsRegistry = antiPornoLimitsRegistry;
        this.limitsManager = limitsManager;
    }

    @ZAction(file = "AntiPornoLimitsAdminPage.xsl", defaultAction = true)
    @Path("/anti-porno-limits")
    public AntiPornoLimitsList antiPornoLimitsList() {
        return new AntiPornoLimitsList(Cf.toList(antiPornoLimitsRegistry.getLimits().values()));
    }

    @ZAction(engineId = "text")
    @Path("/anti-porno-limits/set")
    public EmptyContentPojo setAntiPornoLimits(
            @RequestParam("channel")
            String channel,
            @RequestParam("auth")
            boolean auth,
            @RequestParam(value = "traffic", ignoreEmpty = true, customConverter = ConvertToDataSize.class)
            Option<DataSize> traffic,
            @RequestParam(value = "views", ignoreEmpty = true)
            Option<Long> views)
    {
        limitsManager.changeAntiPornoLimits(channel, auth, traffic, views);
        throw new ZRedirectException("/anti-porno-limits");
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    @XmlRootElement(name = "content")
    static final class AntiPornoLimitsList {
        public final ListF<ChannelLimits> limits;

        public AntiPornoLimitsList(ListF<ChannelLimits> values) {
            limits = values;
        }
    }
}
